 //**************************************************************************
 // Copyright (c) 2008, Carnegie Mellon University.
 // All rights reserved. 
 //
 // Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
 // conditions are met:
 //
 // 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 // disclaimer.
 //
 // 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 // disclaimer in the documentation and/or other materials provided with the distribution.
 // 
 // 3. Neither the name of Carnegie Mellon University nor the names of other contributors may be used to endorse or promote 
 // products derived from this software without specific prior written permission.
 // 
 // THIS SOFTWARE IS PROVIDED BY THE AUTHORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS 
 // BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
 // TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 // AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING // IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 //**************************************************************************
 
 // 1) These additional dependencies need to be added to the Project's Properties for Linker Input
 // libpanda.lib
 // libpandaexpress.lib
 // libp3framework.lib
 // libp3dtool.lib
 // libp3dtoolconfig.lib
 // libp3direct.lib
 // libpandaphysics.lib
 // 2) Also, set the Configuration from "Debug" to "Release" in the "Configuration Manager" at the top-right
 // of Configuration Properties in the Project's Properties.
 
 #include "World.h"
 #include "global.h"
 //#include "InputModule.h"
 
 #include <ctime>
 
 #include "pandaFramework.h"
 #include "pandaSystem.h"
 
 #include "load_prc_file.h"
 
 #ifndef PI
 #define PI 3.14159
 #endif // PI
 
 inline void load_world( WindowFramework& window );
 inline AsyncTask::DoneStatus process_intervals( GenericAsyncTask* task_Ptr, void* data_Ptr );
 
 // This is our task - a global or static function that has to return DoneStatus.
 // The task object is passed as argument, plus a void* pointer, cointaining custom data.
 // For more advanced usage, we can subclass AsyncTask and override the do_task method.
 AsyncTask::DoneStatus spin_camera_task( GenericAsyncTask* task_Ptr, void* data_Ptr )
 {
    // Calculate the new position and orientation (inefficient - change me!)
    double time( global::_clock_Ptr->get_real_time() );
    double angleDegrees( time * 6.0 );
    double angleRadians( angleDegrees * (PI / 180.0) );
    global::_player_1_handler_Ptr->get_camera().set_pos( 20.0f*sin(angleRadians), -20.0f*cos(angleRadians), 3.0f );
    global::_player_1_handler_Ptr->get_camera().set_hpr( angleDegrees, ZERO, ZERO ); // Euler angles - heading, pitch, roll - (horizontal, vertical, tilt)
    
    // Tell the task manager to continue this task the next frame
    return AsyncTask::DS_cont;
 }
 
 int main( int argc, char* argv[] )
 {
    // make the window full screen and display the frames per second
    // load_prc_file_data( "", "fullscreen #t\nshow-frame-rate-meter  #t" );
    
    // display the frames per second
    load_prc_file_data( "", "show-frame-rate-meter  #t" );
    // make the window full screen
    //load_prc_file_data( "", "fullscreen #t" );
    
    // open a new window framework
    global::_framework.open_framework( argc, argv );
    
    // set the window title to My Panda3D Window
    global::_framework.set_window_title( "My Panda3D Window" );
    
    // open the window
    WindowFramework* window_Ptr = global::_framework.open_window();
    
    // here is room for your own code
    if ( window_Ptr != NULL )
        load_world( *window_Ptr );
    
    // Set the clock's average frame rate interval
    global::_clock_Ptr->set_average_frame_rate_interval( 1.0 );
    
    // do the main loop, equal to run() in python
    //global::_framework.main_loop();
    Thread * current_thread( Thread::get_current_thread() );
    while ( global::_framework.do_frame( current_thread ) )
    {
        // manage tasks syncronously
        global::_task_mgr_Ptr->poll();
        global::_action_task_mgr_Ptr->poll();
        
        // handle collisions
        global::_world_Ptr->get_map_area()->get_collision_traverser().traverse( window_Ptr->get_render() );
        
        // adjust the camera for the player
        CameraAdjustment::adjust_camera_to_third_person_character( global::_player_1_handler_Ptr->get_camera(), *global::_player_1_handler_Ptr->get_character(), CAMERA_XY_DISTANCE, CAMERA_HEIGHT );
    }
    
    // close the window framework
    global::_framework.close_framework();
    
    /*std::string test = "test";
    int index( test.find_first_of( " " ) );
    printf("%1d\n", index );
    system("PAUSE");*/
    /*clock_t beginTime( clock() );
    
    size_t i( 0 );
    do
    {
        size_t j( 0 );
        do
        {
            //printf("%1f\n", Math3D::get_readjusted_angle_degrees( -95475.54345f ));
            ++j;
        } while ( j < 1 );
        ++i;
    } while ( i < 99999 );
    
    clock_t endTime( clock() );
    
    std::cout << "TIME: " << (endTime - beginTime) << " milliseconds" << std::endl;
    
    system("PAUSE");*/
    
    return 0;
 }
 
 inline void load_world( WindowFramework& window )
 {
    //window.get_render().set_shader_auto(); // enable shader
    
    global::_world_Ptr = new World< PRIMARY_TYPE >( window );
    global::_world_Ptr->load_world();
    
    // Get the camera and store it
    //global::_cam = window.get_camera_group();
    // Set up camera
    //global::_cam.set_pos( ZERO, ZERO, CAMERA_HEIGHT );
    //global::_cam.set_hpr( ZERO, ZERO, ZERO ); // Euler angles - heading, pitch, roll - (horizontal, vertical, tilt)
    
    // Add our task.
    // If we specify custom data instead of NULL, it will be passed as a second argument
    // to the task function.
    //_task_mgr_Ptr->add( new GenericAsyncTask( "Spins the camera", &SpinCameraTask, (void*) NULL ) );
    
    // setup mouse-control for camera
    // window.setup_trackball();
    
    // Load the default keyboard controls
    //global::_framework.enable_default_keys();
    
    // Load custom keyboard controls
    //InputModule::implement_keyboard_controls( window );
    global::_player_1_handler_Ptr->bind_keyboard_inputs( window );
    
    // process interval animations for the Actor models each frame
    global::_task_mgr_Ptr->add( new GenericAsyncTask( "Process Interval Events", process_intervals, (void*) NULL ) );
 }
 
 /**
  * process_intervals() specifies to process the intervals (movements) 
  * every frame.
  *
  * @param (GenericAsyncTask*) task_Ptr
  * @param (void*) data_Ptr
  * @return AsyncTask::DoneStatus
  */
 inline AsyncTask::DoneStatus process_intervals( GenericAsyncTask* task_Ptr, void* data_Ptr )
 {
    // Step the interval manager
    CIntervalManager::get_global_ptr()->step();
    
    return AsyncTask::DS_cont;
 }
 
 /**
  * load_map() loads the map.
  *
  * @param (WindowFramework&) window
  */
 //inline void load_map( WindowFramework& window )
 //{
    /*
    // Load the environment model
    NodePath environment = window.load_model( global::_framework.get_models(), "models/environment" );
    environment.reparent_to( window.get_render() ); // get_render() returns the root node of the scene graph
                                                    // NodePath (model) must be linked to the scene graph to be rendered
    environment.set_scale( 0.25f, 0.25f, 0.25f ); // geographical coordinate system location (-x, y) at height z
                                                  // gc_x = -x, gc_y = z, gc_z = y  (i.e. (-x, z, y) )
                                                  // the -x axis is the direction left of an object
                                                  // the +y axis is the direction an object should be facing
                                                  // the +z axis is the up direction
    environment.set_pos( -8.0f, 42.0f, ZERO );  // geographical coordinate system location (x, y) at height z
    */
    
    //load_terrain( window );
    //global::_map_area_Ptr->reparent_to( window.get_render() );
    //global::_map_area_Ptr = new TestMapArea< PRIMARY_TYPE >( window.get_render() );
 //}